% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program CSFcomp.m
function [F, df1, df2,  p] = CSFcomp(CSFs)  
                        % CSFs contains the measured CSFs

NCSF = size(CSFs, 1)/2; % compute # of CSFs for comparison

% full model fit
fullmodel_L=0;
for i = 1: NCSF
        data =  CSFs( (i-1)*2+1 : (i*2), :);
        guess = [200 1.0 8 0.5]; % Gmax, Fmax, beta, delta
        options = optimset('fminsearch');
        [guess, L] = fminsearch('CSFcostfunc', guess, ...
                     options, data);
        fullmodel_L = fullmodel_L + L;
end
  
%reduced model: same parameters for all CSFs
data = CSFs;
guess = [200 1.0 8 0.5];   % Gmax, Fmax, beta, delta
options = optimset('fminsearch');
[guess, L] = fminsearch('CSFcomp_costfunc', guess, ...
        options, data);
reducedmodel_L = L;

meanLogS = mean(mean(log10(CSFs(2:2:(2*NCSF), :))));
SS = sum(sum((log10(CSFs(2:2:(2*NCSF), :)) - ...
        meanLogS).^2));
r2_full = 1 - fullmodel_L/SS;
r2_reduced = 1 - reducedmodel_L/SS;
df1 = 4*(NCSF-1);
df2 = size(CSFs, 2)*NCSF - 4*NCSF;
F = (r2_full - r2_reduced)/df1 / ((1 - r2_full)/df2);
p = 1 - fcdf(F, df1, df2);

